import validateConnectDomain from '@blocks/registration/methods/validateDomain';
import checkIfInvalid from '@blocks/registration/methods/checkIfInvalid';
import {updateValues, updateHintStatus} from '@blocks/actions/form';

/* eslint-disable no-invalid-this */

export function construct(props) {
    this.stopNumbers = props.isMobile
        ? {
              main: 11,
              sub: 20
          }
        : {
              main: 17,
              sub: 19
          };
}

export function handleInput(event) {
    const {target = {}} = event;
    const {value} = target;
    const field = 'domain';

    this.props.dispatch(updateValues({field, value}));
    handleValidation.call(this, value);
    if (value.length > this.stopNumbers.main && !this.state.placeholderHidden && !this.timer) {
        this.timer = setTimeout(() => {
            this.timer = null;
            this.setState({placeholderHidden: true});
        }, 500);
    } else if (this.timer) {
        clearTimeout(this.timer);
        this.timer = null;
    } else if (this.state.placeholderHidden) {
        this.setState({placeholderHidden: false});
    }
}

export function handleValidation(value) {
    this.props.dispatch(validateConnectDomain(value));
}

export function handleFocus() {
    stateHandler.call(this, true);
    this.props.dispatch(checkIfInvalid('domain'));
}

export function handleBlur() {
    stateHandler.call(this, false);
}

export function stateHandler(focused) {
    this.setState({focused});
    this.props.dispatch(updateHintStatus(focused));
}

export function checkErrorVisibility() {
    const {state, value: domain, active, isMobile} = this.props;
    const invalid = state === 'not_valid';

    if (isMobile) {
        return invalid;
    }

    return invalid && active && (domain.length > 0 || !this.state.focused);
}
