import React from 'react';

import {Checkbox} from '@components/Checkbox';
import {Button} from '@components/Button';
import EulaPopup from '@blocks/registration/desktop/eula/EulaPopup.jsx';
import regMethods from '@blocks/registration/methods/basicRegistrationMethods';
import returnFormData from '@blocks/registration/methods/returnFormData';
import scrollToError from '@blocks/registration/methods/scrollToError';
import {
    updateErrorStates,
    updateQuestionCustomState,
    updateErrors,
    updateGroupErrors,
    updateValues,
    updateErrorsValid
} from '@blocks/actions/form';
import {showEulaPopup} from '@blocks/registration/actions';
import {errorsTxt} from '@blocks/registration/errors.js';
import metrics from '@blocks/metrics';
import processPhoneData from '@blocks/registration/methods/phoneConfirmation/processPhoneData';

/* eslint-disable no-invalid-this */

export function updateUserField(event) {
    const {target = {}} = event;
    const {value, name} = target;
    const fieldInfo = {
        field: name,
        value
    };

    this.props.dispatch(updateValues(fieldInfo));
    this.props.dispatch(updateErrorsValid(name));
}

export function onFormSubmit(evt) {
    evt.preventDefault();

    metrics.send(['Форма', 'Попытка отправки']);
    metrics.goal(`${this.prefix}_form_submitted`);

    validateForm.call(this);
}

/* eslint-disable complexity */
/* eslint-disable guard-for-in */
export function validateForm() {
    if (!this.state.eulaChecked) {
        return;
    }

    const {form, dispatch} = this.props;
    const {validation, errors, isEulaShowedInPopup} = form;
    const states = Object.assign({}, form.states);
    const values = Object.assign({}, form.values);
    const method = validation.method;
    const validatedStates = regMethods.prepareFormData(states, method, this.isMobile);
    const emptyFields = {};
    const errorFields = {};

    let isValid = true;

    if (!validation.humanConfirmationDone && method === 'phone') {
        isValid = false;

        if (!values.phoneCode) {
            dispatch(processPhoneData());
            return;
        }
    }

    if (method === 'captcha') {
        if (values.hint_question_id === '99' && !values.hint_question_custom) {
            const hintQuestionErrorObj = {
                code: 'missingvalue',
                text: errorsTxt.hint.hintQuestionErrors.missingvalue
            };

            states.hint_question_custom = 'not_valid';
            dispatch(updateQuestionCustomState({status: 'not_valid'}));
            dispatch(updateErrors({field: 'hint_question_custom', error: hintQuestionErrorObj, active: true}));
        }

        if (values.hint_question_id === '99') {
            values.hint_question = values.hint_question_custom;
        }
    }

    for (const fieldName in validatedStates) {
        const hasWarningStatus = fieldName === 'password' && errors[fieldName].warning;

        let inValidFieldError = errorsTxt[fieldName];

        if (states[fieldName] === 'valid' || hasWarningStatus) {
            continue;
        }

        isValid = false;
        emptyFields[fieldName] = 'not_valid';

        if (inValidFieldError) {
            const errorCode = errors[fieldName].code || 'missingvalue';
            const isEmptyPhone = fieldName === 'phone' && errorCode === 'missingvalue';

            errorFields[fieldName] = {
                code: errorCode,
                text: errorsTxt[fieldName].errors[errorCode],
                descriptionText: errorsTxt[fieldName].descriptions ? errorsTxt[fieldName].descriptions[errorCode] : ''
            };

            if (isEmptyPhone) {
                errorFields[fieldName].text = errorsTxt.phone.errors.needsconfirmation;
            }

            inValidFieldError = false;
        }
    }

    if (!isValid) {
        const add = this.isMobile ? 100 : 0;

        dispatch(updateErrorStates(emptyFields));
        dispatch(updateGroupErrors(Object.assign({}, {active: Object.keys(errorFields)[0]}, errorFields)));

        metrics.send(['Форма', 'Показ ошибок']);
        metrics.goal(`${this.prefix}_form_invalid`);

        scrollToError(document.querySelector(`#${Object.keys(emptyFields)[0]}`), undefined, add);
    } else {
        values['human-confirmation'] = method;
        if (isEulaShowedInPopup) {
            dispatch(showEulaPopup(true));
            metrics.send(['Форма', 'Показ попапа с Eula']);
            return;
        }
        dispatch(regMethods.submitRegistration(values, true));

        metrics.send(['Форма', 'Отправка формы']);
        metrics.goal(`${this.prefix}_form_valid`);
    }
}

export function handleEula() {
    this.setState((prevState) => ({
        eulaChecked: !prevState.eulaChecked
    }));
}

export function eula() {
    if (this.props.form.isEulaShowedInPopup) {
        return null;
    }
    return (
        <>
            <div className='form__eula'>
                <Checkbox
                    size='m'
                    id='the-id2-theme-normal'
                    name='the-name-theme-normal'
                    checked={this.state.eulaChecked}
                    onChange={this.handleEula}
                    dangerouslyLabel={i18n('EULA.acceptance.workspace')}
                />
            </div>
        </>
    );
}

export function submit() {
    const {phoneCodeStatus, phoneCode} = this.props.form.states;
    const phoneConfirmationInProcess = phoneCodeStatus === 'code_sent' && phoneCode !== 'valid';
    const isDisabled = !this.state.eulaChecked || this.props.isFetching || phoneConfirmationInProcess || this.isLoading;

    return (
        <div>
            {/* PASSP-20338: Троббер на регистрации коннекта без JS */}
            {this.isLoading && (
                <div className='no-js-submit'>
                    <Button view='action' size='l' width='max' type='submit'>
                        {i18n('Profile.regpromo.register')}
                    </Button>
                </div>
            )}
            <div className='js-submit'>
                <Button
                    view='action'
                    size='l'
                    width='max'
                    type='submit'
                    disabled={isDisabled}
                    onClick={this.onFormSubmit}
                >
                    {i18n('Profile.regpromo.register')}
                </Button>
            </div>
            <EulaPopup sendData={this.sendFormData} />
        </div>
    );
}

export function sendFormData() {
    const {dispatch} = this.props;
    const data = dispatch(returnFormData(false));

    dispatch(regMethods.submitRegistration(data, true));
}
