import React from 'react';
import PropTypes from 'prop-types';

import {Spin} from '@components/Spin';

import {REGISTRATION_PDD_GOAL_PREFIX} from '../registration/actions';

import UserPassword from '../registration/fieldComponents/userpassword.jsx';
import PhoneConfirmation from '../registration/fieldComponents/human_confirmation/phone_confirm/phone_confirmation.jsx';
import RegistrationNameInput from '../registration/fieldComponents/name/name_input.jsx';
import RegistrationSurnameInput from '../registration/fieldComponents/surname/surname_input.jsx';
import DomainInput from './domain_input.jsx';
import LoginInput from './login_input.jsx';

import * as extracted from './form.js';

export default class Form extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            eulaChecked: true
        };
        this.isMobile = this.props.isMobile;
        this.prefix = REGISTRATION_PDD_GOAL_PREFIX;
        this.onFormSubmit = extracted.onFormSubmit.bind(this);
        this.validateForm = extracted.validateForm.bind(this);
        this.handleEula = extracted.handleEula.bind(this); // don't touch this!
        this.updateUserField = extracted.updateUserField.bind(this);
        this.eula = extracted.eula.bind(this);
        this.submit = extracted.submit.bind(this);
        this.sendFormData = extracted.sendFormData.bind(this);

        this.isLoading = true;
    }

    componentDidMount() {
        this.isLoading = false;
        this.forceUpdate();
    }

    static FieldsText() {
        return (
            <div className='registration__form-block'>
                <h4 className='registration__form-title'>{i18n('Frontend.workspace_registration_about_text')}</h4>
                <div className='form-block__text'>
                    <p dangerouslySetInnerHTML={{__html: i18n('Frontend.workspace_registration_about_descr')}} />
                </div>
            </div>
        );
    }

    render() {
        const {form, dispatch, registrationErrors, isFetching, service, isMobile} = this.props;
        const {activeField, humanConfirmation, states, values, errors, validation} = form;

        return (
            <form
                className={`registration__form connect__form registration__form_${isMobile ? 'mobile' : 'desktop'}`}
                autoComplete='off'
                method='post'
                onSubmit={this.onFormSubmit}
            >
                <div className='registration__form-block'>
                    <h4 className='registration__form-title title__margin'>
                        {i18n('Frontend.workspace_domain_input_title')}
                    </h4>
                    <DomainInput
                        isMobile={isMobile}
                        state={states.domain}
                        value={values.domain}
                        autoFocus={true}
                        error={errors.domain}
                        active={errors.active === 'domain'}
                        dispatch={dispatch}
                        service={service}
                    />
                </div>
                <Form.FieldsText />
                <RegistrationNameInput
                    dispatch={dispatch}
                    value={values.firstname}
                    state={states.firstname}
                    activeError={errors.active}
                    activeField={activeField}
                    isAutoFocuseDisabled={true}
                    error={errors.firstname}
                    updateUserField={this.updateUserField}
                />
                <RegistrationSurnameInput
                    dispatch={dispatch}
                    isMobile={isMobile}
                    value={values.lastname}
                    state={states.lastname}
                    error={errors.lastname}
                    hintActive={errors.hintActive}
                    activeField={activeField}
                    updateUserField={this.updateUserField}
                />
                <LoginInput isMobile={isMobile} states={states} values={values} errors={errors} dispatch={dispatch} />
                <UserPassword isMobile={isMobile} states={states} values={values} errors={errors} dispatch={dispatch} />
                <PhoneConfirmation
                    isMobile={isMobile}
                    activeError={errors.active}
                    dispatch={dispatch}
                    value={values.phone}
                    passwordValue={values.password}
                    state={states.phone}
                    phoneCodeStatus={states.phoneCodeStatus}
                    phoneCode={states.phoneCode}
                    validation={validation}
                    prefix={this.prefix}
                    canSwitchConfirmationMethod={false}
                    isPhoneCallConfirmationAvailable={false}
                    phoneCodeValue={values.phoneCode}
                    humanConfirmation={humanConfirmation}
                    errors={errors}
                />
                <div className='form__submit'>
                    {!isFetching && this.submit()}
                    <Spin progress={isFetching || this.isLoading} className='js-submit' size='l' />
                </div>
                {registrationErrors.status === 'global' && <p className='error'>{registrationErrors.text}</p>}
                {this.eula()}
            </form>
        );
    }
}

Form.propTypes = {
    dispatch: PropTypes.func.isRequired,
    form: PropTypes.object.isRequired,
    registrationErrors: PropTypes.object.isRequired,
    isFetching: PropTypes.bool.isRequired,
    service: PropTypes.string.isRequired,
    isMobile: PropTypes.bool
};
