import validateConnectLogin from '@blocks/registration/methods/validateConnectLogin';
import checkIfInvalid from '@blocks/registration/methods/checkIfInvalid';
import {updateValues, updateErrorsValid, updateStates, updateErrors} from '@blocks/actions/form';

/* eslint-disable no-invalid-this */

export function construct(props) {
    this.state = {
        focused: false,
        placeholderHidden: false
    };
    this.stopNumbers = {
        main: props.isMobile ? 2 : 0,
        sub: 3
    };
}

export function shouldComponentUpdate({states: nextStates, values: nextValues, errors: nextErrors}, {focused}) {
    const {states, values, errors} = this.props;

    return (
        focused !== this.state.focused ||
        errors.login.code !== nextErrors.login.code ||
        states.login !== nextStates.login ||
        states.domain !== nextStates.domain ||
        values.login !== nextValues.login ||
        values.domain !== nextValues.domain ||
        (errors.active === 'login' && nextErrors.active !== 'login') ||
        errors.hintActive !== nextErrors.hintActive
    );
}

export function handleInput(event) {
    const {target = {}} = event;
    const {value} = target;
    const field = 'login';
    const fieldInfo = {field, value};

    this.props.dispatch(updateValues(fieldInfo));
    this.props.dispatch(updateErrorsValid(field));
    this.handleValidation(value);
    if (isValueTooLong.call(this, value) && !this.state.placeholderHidden && !this.timer) {
        this.timer = setTimeout(() => {
            this.timer = null;
            this.setState({placeholderHidden: true});
        }, 500);
    } else if (this.timer) {
        clearTimeout(this.timer);
        this.timer = null;
    } else if (this.state.placeholderHidden) {
        this.setState({placeholderHidden: false});
    }
}

export function handleValidation(value) {
    const dispatch = this.props.dispatch;

    if (!this.props.values.domain) {
        const field = 'login';

        dispatch(updateStates({field, status: 'not_valid'}));
        dispatch(
            updateErrors({
                field,
                error: {
                    code: 'login.no_domain',
                    text: i18n('Frontend.login.no_domain.error'),
                    descriptionText: i18n('Frontend.login.no_domain.desc')
                },
                active: true
            })
        );
        return;
    }

    dispatch(validateConnectLogin(value));
}

export function handleFocus() {
    this.setState({
        focused: true
    });
    this.props.dispatch(checkIfInvalid('login'));
}

export function onBlur() {
    this.setState({
        focused: false
    });
}

export function getDomainLength() {
    const {
        states: {domain: domainState},
        values: {domain}
    } = this.props;

    return domainState !== 'valid' ? 4 : Math.max(domain.length >= 10 ? 12 : domain.length, 4);
}

export function isValueTooLong(value) {
    return getDomainLength.call(this) + value.length > 15 - this.stopNumbers.main;
}
