import React from 'react';
import PropTypes from 'prop-types';

const ConnectMobileHeader = (props) => {
    const {isMobile, links, logos, serviceLink, origin, texts, servicesList} = props;

    if (isMobile) {
        return (
            <div className='step registration__header_mobile'>
                <div className='logo'>
                    <a href={links.yandex} className='service__yandex'>
                        <img src={logos.yandex} />
                    </a>
                    <a href={serviceLink} className={`service__${origin}`}>
                        <img src={logos.service} />
                    </a>
                </div>
                <h1 className='step__title'>{texts[origin].title}</h1>
                <ul className='connect__icons'>
                    {servicesList.map((service) => (
                        <li className='connect__icon' key={service}>
                            <span className={`mobile__icon-${service}`} />
                        </li>
                    ))}
                </ul>
            </div>
        );
    }
    return null;
};

ConnectMobileHeader.propTypes = {
    isMobile: PropTypes.bool,
    links: PropTypes.string,
    logos: PropTypes.shape({
        yandex: PropTypes.string,
        service: PropTypes.string
    }).isRequired,
    serviceLink: PropTypes.string,
    origin: PropTypes.string,
    texts: PropTypes.object,
    servicesList: PropTypes.array
};

export default ConnectMobileHeader;
