import React from 'react';
import PropTypes from 'prop-types';
import {Footer} from '@components/Footer/Footer.jsx';
import {ServicesSVG} from './services.jsx';

export default function Promo({registrationErrors, service, links, texts, logos, footer}) {
    const {name, list, link} = service;
    const regErrorText = () => (
        <div>
            <strong>{registrationErrors.text}</strong>
            <p dangerouslySetInnerHTML={{__html: registrationErrors.descriptionText}} />
        </div>
    );

    return (
        <div className='presentation'>
            <ServicesSVG />
            <div className='presentation__wrapper'>
                <div className='logo'>
                    <a href={links.yandex} className='service__yandex'>
                        <img src={logos.yandex} />
                    </a>
                    <a href={link} className={`service__${name}`}>
                        <img src={logos.service} />
                    </a>
                </div>
                <h2 className='description__text'>{texts.title}</h2>
                <ul className='services__icons'>
                    {list.map((item) => (
                        <li className={`service__icon icon-${item}`} key={item}>
                            <svg>
                                <use xlinkHref={`#${item}`} />
                            </svg>
                        </li>
                    ))}
                </ul>
                <div className='presentation__about'>{texts.desc}</div>
                {registrationErrors.status === 'error' && <div className='presentation__about'>{regErrorText()}</div>}
            </div>
            <Footer {...footer} page='registration' />
        </div>
    );
}

Promo.propTypes = {
    registrationErrors: PropTypes.object.isRequired,
    service: PropTypes.shape({
        name: PropTypes.string.isRequired,
        list: PropTypes.array.isRequired,
        link: PropTypes.string.isRequired
    }).isRequired,
    logos: PropTypes.shape({
        yandex: PropTypes.string.isRequired,
        service: PropTypes.string.isRequired
    }).isRequired,
    links: PropTypes.shape({
        yandex: PropTypes.string.isRequired,
        service: PropTypes.string.isRequired
    }).isRequired,
    texts: PropTypes.shape({
        title: PropTypes.string.isRequired,
        desc: PropTypes.string.isRequired
    }).isRequired,
    footer: PropTypes.shape({
        env: PropTypes.object.isRequired,
        langlist: PropTypes.array.isRequired,
        language: PropTypes.string.isRequired,
        tld: PropTypes.string.isRequired,
        help: PropTypes.object.isRequired
    }).isRequired
};
