import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import CaptchaComponent from './components/captcha.jsx';

class CaptchaContainer extends PureComponent {
    static mapStateToProps(state) {
        const {common, captcha, settings} = state;
        const {ua, tld, language} = settings;
        const isMobileCaptcha = Boolean(ua.isMobile || ua.isTablet);

        return {
            tld,
            language,
            isMobileCaptcha,
            captcha,
            common
        };
    }

    render() {
        return <CaptchaComponent {...this.props} />;
    }
}

const WrappedCaptchaContainer = connect(CaptchaContainer.mapStateToProps)(CaptchaContainer);

export default WrappedCaptchaContainer;
