import {routerReducer} from 'react-router-redux';
import header from '@blocks/morda/components/header/reducers';
import person from '@blocks/morda/personal_info/reducers.js';
import common from '@blocks/common/reducers';
import captcha from '@components/Captcha/reducers';
import domik from '@blocks/morda/components/domik/reducers';
import yamoney from '@blocks/morda/components/money/reducers';
import deleteAccount from './reducers';
import countDown from '@blocks/common/phone_countdown/reducers';

function personalInfo(state, action) {
    return person(state, action);
}

export default function rootReducer(state = {}, action) {
    const newState = {};

    for (const key in state) {
        newState[key] = state[key];
    }

    newState.header = header(state.header, action);
    newState.person = personalInfo(state.person, action);
    newState.access = (accessState) => accessState;
    newState.common = common(state.common, action);
    newState.routing = routerReducer(state.routing, action);
    newState.captcha = captcha(state.captcha, action);
    newState.domik = domik(state.domik, action);
    newState.yamoney = yamoney(state.yamoney, action);
    newState.countDown = countDown(state.countDown, action);
    newState.deleteAccount = deleteAccount(state.deleteAccount, action);
    return newState;
}
