import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Captcha} from '@components/Captcha';

export default class CaptchaComponent extends Component {
    render() {
        const {language, isMobileCaptcha, captcha, dispatch} = this.props;

        return (
            <div className='delete-account__field-item delete-account__captcha'>
                <Captcha
                    isMobile={isMobileCaptcha}
                    lang={language}
                    introSound={captcha.introSound}
                    captchaSound={captcha.captchaSound}
                    imageUrl={captcha.imageUrl}
                    loading={captcha.loading}
                    loadingAudio={captcha.loadingAudio}
                    playing={captcha.playing}
                    type={captcha.type}
                    dispatch={dispatch}
                    visible={true}
                />
            </div>
        );
    }
}

CaptchaComponent.propTypes = {
    isMobileCaptcha: PropTypes.bool,
    language: PropTypes.string.isRequired,
    captcha: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired
};
