import React, {Component} from 'react';
import PropTypes from 'prop-types';
import SubscriptionsWarning from './subscriptionsWarning.jsx';
import DeletionChecks from './deletionChecks.jsx';

export default class DeleteForm extends Component {
    render() {
        const {
            subscribedTo,
            confirmation,
            captchaPassed,
            form,
            error,
            hasBlockingSids,
            isFetching
        } = this.props.deleteAccount;
        const {isMobile, dispatch, text, isAppMode} = this.props;
        const blockTitle = hasBlockingSids
            ? i18n('ProfileDelete.delete.sid_list-description')
            : i18n('ProfileDelete.delete.sid_list_title');

        return (
            <div>
                <div className='delete-description' dangerouslySetInnerHTML={{__html: text}} />
                <SubscriptionsWarning isAppMode={isAppMode} subscribedTo={subscribedTo} blockTitle={blockTitle} />
                <DeletionChecks
                    isMobile={isMobile}
                    confirmation={confirmation}
                    captchaPassed={captchaPassed}
                    error={error}
                    form={form}
                    isFetching={isFetching}
                    dispatch={dispatch}
                    isAppMode={isAppMode}
                />
            </div>
        );
    }
}

DeleteForm.propTypes = {
    deleteAccount: PropTypes.shape({
        subscribedTo: PropTypes.object,
        confirmation: PropTypes.object,
        captchaPassed: PropTypes.bool,
        form: PropTypes.object,
        error: PropTypes.object,
        hasBlockingSids: PropTypes.bool,
        isFetching: PropTypes.bool
    }),
    isMobile: PropTypes.bool,
    dispatch: PropTypes.func.isRequired,
    text: PropTypes.string,
    isAppMode: PropTypes.bool
};
