import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import deleteAccountCommit from '../thunks/delete_account_commit';
import classnames from 'classnames';
import metrics from '../../metrics';

class DeleteWarning extends PureComponent {
    constructor(props) {
        super(props);

        this.confirmDelete = this.confirmDelete.bind(this);
    }

    static sendMetrics() {
        metrics.send(['Отмена удаления аккаунта']);
    }

    confirmDelete(e) {
        e.preventDefault();
        this.props.dispatch(deleteAccountCommit());
        metrics.send(['Подтверждение удаления аккаунта']);
    }

    componentDidMount() {
        // https://st.yandex-team.ru/PASSP-19224
        document.getElementById('deleteFormSubmit').focus();
    }

    render() {
        const {text, isMobile, isAppMode} = this.props;

        return (
            <div className={classnames('delete__warning utilityfocus', {'p-control-modal': !isMobile})}>
                <h2 className='section-title'>{i18n('ProfileDelete.confirm-delete')}</h2>
                <form onSubmit={this.confirmDelete}>
                    <div className='delete__warning-text' dangerouslySetInnerHTML={{__html: text}} />
                    <div className='delete__warning-buttons'>
                        <div className='left-aligned'>
                            <Button
                                view='pseudo'
                                size='l'
                                type='link'
                                onClick={DeleteWarning.sendMetrics}
                                url={isAppMode ? '/closewebview?status=close' : '/profile'}
                                dataT='delete-warning-cancel'
                                width={isMobile ? 'max' : ''}
                            >
                                {i18n('_AUTH_.common.cancel')}
                            </Button>
                        </div>
                        <div className='right-aligned'>
                            <Button
                                view='action'
                                id='deleteFormSubmit'
                                size='l'
                                onClick={this.confirmDelete}
                                dataT='delete-warning-confirm'
                                width={isMobile ? 'max' : ''}
                            >
                                {i18n('Profile.personal.hangover.remove')}
                            </Button>
                        </div>
                    </div>
                </form>
            </div>
        );
    }
}

export default DeleteWarning;

DeleteWarning.propTypes = {
    hasBlockingSids: PropTypes.bool,
    hasMailSid: PropTypes.bool,
    dispatch: PropTypes.func.isRequired,
    text: PropTypes.string,
    isMobile: PropTypes.bool,
    isAppMode: PropTypes.bool
};
