import React from 'react';
import PropTypes from 'prop-types';

const InputError = ({error}) => {
    const {field, message} = error;

    if (field === 'code') {
        return <div className='errors-block input-error error-block_code'>{message}</div>;
    }
    return null;
};

export default InputError;

InputError.propTypes = {
    error: PropTypes.shape({
        field: PropTypes.string,
        message: PropTypes.string
    })
};
