import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import updateFormFields from '../helpers/update_form_fields';

class QuestionCheck extends Component {
    constructor(props) {
        super(props);
        this.onInputAnswer = this.onInputAnswer.bind(this);
    }

    onInputAnswer(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const fieldInfo = {};

        fieldInfo[name] = value;
        this.props.dispatch(updateFormFields(fieldInfo));
    }

    render() {
        const {confirmation, error, form} = this.props;
        const questionText = confirmation ? confirmation.questionText : '';

        return (
            <div className='delete-account_question delete-account__fields'>
                <div className='delete-account__control-label'>{questionText}:</div>
                <div className='delete-account__control-input'>
                    <Input
                        size='l'
                        id='answer'
                        value={form.answer}
                        hasClear={true}
                        placeholder={i18n('_AUTH_.field_hint_answer')}
                        name='answer'
                        onChange={this.onInputAnswer}
                    />

                    {error.field === 'question' && (
                        <div className='errors-block input-error error-block_code'>{error.message}</div>
                    )}
                </div>
            </div>
        );
    }
}

export default QuestionCheck;

QuestionCheck.propTypes = {
    confirmation: PropTypes.shape({
        method: PropTypes.string,
        status: PropTypes.string,
        questionText: PropTypes.string
    }).isRequired,
    form: PropTypes.object,
    error: PropTypes.object,
    dispatch: PropTypes.func.isRequired
};
