import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import classnames from 'classnames';

const ServiceItem = (props) => {
    const {name, locName, url, isBlocking, description, isAppMode} = props;
    const iconClass = `sid-icon ${name}-icon`;

    if (!name) {
        return null;
    }

    return (
        <div>
            <dt className='delete-sids-name'>
                <span className={iconClass} title={locName} />
                <span className='sid-name'>
                    {isAppMode ? (
                        locName
                    ) : (
                        <Link href={url} target='_blank'>
                            {locName}
                        </Link>
                    )}
                </span>
            </dt>
            <dd className={classnames('delete-sids-description', {is_blocking: isBlocking})}>
                <p>{description}</p>
            </dd>
        </div>
    );
};

export default ServiceItem;

ServiceItem.propTypes = {
    name: PropTypes.string,
    locName: PropTypes.string,
    url: PropTypes.string,
    isBlocking: PropTypes.bool,
    description: PropTypes.string,
    isAppMode: PropTypes.bool
};
