import React from 'react';
import PropTypes from 'prop-types';
import ServiceItem from './serviceItem.jsx';

const SubscriptionsWarning = ({subscribedTo, blockTitle, isAppMode}) => {
    const {mainList, secondaryList} = subscribedTo;
    const hasAnySubscriptions = mainList.length > 0 || secondaryList.length > 0;
    const isMainListEmpty = mainList.length === 0;
    const secondaryListText = isMainListEmpty ? '' : i18n('ProfileDelete.secondary_text');

    if (hasAnySubscriptions) {
        return (
            <div className='delete__service-list'>
                <h4 className='delete__service-list__title'>{blockTitle}</h4>
                {mainList.length > 0 && (
                    <dl className='delete__sids-list'>
                        {subscribedTo.mainList.map((service) => (
                            <ServiceItem
                                key={service.id}
                                name={service.name}
                                locName={service.locName}
                                isBlocking={service.isBlocking}
                                url={service.url}
                                description={service.description}
                                isAppMode={isAppMode}
                            />
                        ))}
                    </dl>
                )}
                {secondaryList.length > 0 && (
                    <div className='delete__sids__secondary-list'>
                        <strong className='secondary__list-text'>{secondaryListText}</strong>
                        {subscribedTo.secondaryList.map((service) => (
                            <span key={service.id}>{service.locName}</span>
                        ))}
                    </div>
                )}
            </div>
        );
    }
    return null;
};

SubscriptionsWarning.propTypes = {
    subscribedTo: PropTypes.shape({
        mainList: PropTypes.array,
        secondaryList: PropTypes.array
    }).isRequired,
    blockTitle: PropTypes.string,
    isAppMode: PropTypes.bool
};

export default SubscriptionsWarning;
