import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import DeleteComponent from './components/deleteComponent.jsx';
import {connect} from 'react-redux';

class DeleteContainer extends PureComponent {
    static mapStateToProps(state) {
        const {deleteAccount, settings, common} = state;
        const {ua, tld, language} = settings;
        const {currentPage, isAppMode} = common;
        const isMobile = Boolean((ua.isMobile || ua.isTouch) && !ua.isTablet);
        const isTablet = ua.isTouch && ua.isTablet;

        return {
            tld,
            language,
            isMobile,
            isTablet,
            currentPage,
            deleteAccount,
            isAppMode
        };
    }

    render() {
        return <DeleteComponent {...this.props} />;
    }
}

const WrappedDeleteContainer = connect(DeleteContainer.mapStateToProps)(DeleteContainer);

export default WrappedDeleteContainer;

DeleteContainer.propTypes = {
    tld: PropTypes.string,
    language: PropTypes.string,
    isMobile: PropTypes.bool,
    isTablet: PropTypes.bool,
    currentPage: PropTypes.string,
    deleteAccount: PropTypes.shape({
        subscribedTo: PropTypes.object,
        hasCaptchaPassed: PropTypes.bool,
        confirmation: PropTypes.object,
        error: PropTypes.object,
        hasBlockingSids: PropTypes.bool,
        form: PropTypes.object
    })
};
