import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {deleteAccountCommit} from './';

class DeleteWarning extends Component {
    constructor(props) {
        super(props);
        this.getMessageText = this.getMessageText.bind(this);
        this.confirmDelete = this.confirmDelete.bind(this);
    }

    confirmDelete() {
        this.props.dispatch(deleteAccountCommit());
    }

    getMessageText() {
        const {hasBlockingSids} = this.props;

        if (hasBlockingSids) {
            return i18n('ProfileDelete.popup_delete-blocking-sid-text');
        }
        return i18n('ProfileDelete.popup_delete-text');
    }

    render() {
        const message = this.getMessageText();

        return (
            <div className='p-control-form p-control-modal delete__warning'>
                <h2 className='section-title'>{i18n('ProfileDelete.confirm-delete')}</h2>
                <div className='delete__warning-text'>{message}</div>
                <div className='delete__warning-buttons'>
                    <div className='left-aligned'>
                        <Button view='pseudo' size='l' type='link' url='/profile'>
                            {i18n('_AUTH_.common.cancel')}
                        </Button>
                    </div>
                    <div className='right-aligned'>
                        <Button view='action' size='l' onClick={this.confirmDelete}>
                            {i18n('Profile.personal.hangover.remove')}
                        </Button>
                    </div>
                </div>
            </div>
        );
    }
}

export default DeleteWarning;

DeleteWarning.propTypes = {
    hasBlockingSids: PropTypes.bool,
    dispatch: PropTypes.func.isRequired
};
