import checkCaptcha from '../thunks/check_captcha';
import sendConfirmation from '../thunks/send_confirmation';
import checkCode from '../thunks/check_code';
import questionCheck from '../thunks/question_check';
import processError from './process_error';
import {setModalStatus} from '../actions';

export default function initDeleteProcess() {
    return (dispatch, getState) => {
        const state = getState().deleteAccount;
        const {method, status} = state.confirmation;
        const {code, answer, captcha} = state.form;

        if (method === 'skip') {
            dispatch(setModalStatus(true));
            return;
        }

        if (method === 'captcha') {
            dispatch(checkCaptcha());
            return;
        }

        if (method === 'phone' || method === 'email') {
            const unconfirmed = status === 'unconfirmed' || status === 'skip_captcha';

            if (!captcha) {
                dispatch(processError('captcha', 'captcha.empty'));
                return;
            }
            if (unconfirmed && !code) {
                dispatch(sendConfirmation(state.form, method));
                return;
            }
            dispatch(checkCode(code, method));
        } else {
            dispatch(questionCheck(answer));
        }
    };
}
