import {updateError} from '@blocks/delete/actions';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';

export default function processError(field = 'global', error = 'error.global') {
    return (dispatch) => {
        const errorCode = error;
        const errors = {
            'captcha.captcheserver': i18n('_AUTH_.answer_errors_captchalocate'),
            'captcha.toolong': i18n('Errors.AutoLogin.autologin_badcaptcha'),
            'captcha.empty': i18n('_AUTH_.Errors.captcha.required'),
            'captcha.required': i18n('_AUTH_.Errors.captcha.required'),
            'captcha.missingvalue': i18n('_AUTH_.Errors.captcha.required'),
            'sms_limit.exceeded': i18n('_AUTH_.phones.errors.limit-exceeded'),
            'email.missingvalue': i18n('Frontend.field_email_error'),
            'email_confirmations_limit.exceeded': i18n('_AUTH_.question.attempts_limit_exceeded'),
            'email_messages_limit.exceeded': i18n('_AUTH_.question.attempts_limit_exceeded'),
            'email.invalid': i18n('Errors.import.email_incorrect'),
            'confirmations_limit.exceeded': i18n('_AUTH_.question.attempts_limit_exceeded'),
            'answer.missingvalue': i18n('_AUTH_.hint_answer_errors_missingvalue'),
            'answer.not_matched': i18n('Errors.import.answer_not_matched'),
            invalid: i18n('_AUTH_.answer_errors_captchalocate'),
            'captcha.captchalocate': i18n('_AUTH_.answer_errors_captchalocate'),
            'captcha.not_matched': i18n('Errors.AutoLogin.autologin_badcaptcha'),
            'code.empty': i18n('Frontend.profile_hack_page_title'),
            'code.missingvalue': i18n('Frontend.profile_hack_page_title'),
            'code.invalid': i18n('Profile.emails.errors.code-invalid'),
            'code.wasntsend': i18n('ProfileDelete.code_error_wasnt-send'),
            'error.global': i18n('Profile.addresses.errors.internal'),
            'email.not_suitable': i18n('_AUTH_.error.email-not-found'),
            'user.not_verified': i18n('_AUTH_.Errors.internal'),
            'action.not_required': i18n('_AUTH_.Errors.internal')
        };
        const needCaptchaReload = [
            'captcha.captchalocate',
            'captcha.not_matched',
            'captcha.invalid',
            'captcha.empty',
            'captcha.missingvalue'
        ];
        const errorData = {
            field,
            message: errors[errorCode]
        };

        if (errorCode === 'password.required') {
            // password errors handles by domik
            return;
        }

        if (errorCode === 'account.disabled') {
            window.location.href = '/auth';
        }

        if (needCaptchaReload.indexOf(error) !== -1) {
            dispatch(reloadCaptcha());
        }
        dispatch(updateError(errorData));
    };
}
