import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';
import {Button} from '@components/Button';
import {Link} from '@components/Link';
import {sendConfirmation, updateFormFields} from './';
import {checkStatus} from './actions';

class PhoneCheck extends Component {
    constructor(props) {
        super(props);
        this.sendCode = this.sendCode.bind(this);
        this.sendCodeAgain = this.sendCodeAgain.bind(this);
        this.onInputCode = this.onInputCode.bind(this);
    }

    sendCode() {
        const {form, dispatch} = this.props;

        dispatch(sendConfirmation(form, 'phone'));
    }

    sendCodeAgain() {
        this.props.dispatch(checkStatus('skip_captcha'));
        this.sendCode();
    }

    onInputCode(event) {
        const {target = {}} = event;
        const {value, name} = target;
        const fieldInfo = {};

        fieldInfo[name] = value;
        this.props.dispatch(updateFormFields(fieldInfo));
    }

    render() {
        const {phone, countdown, status} = this.props.phoneInfo;
        const {form, error} = this.props;

        return (
            <div>
                {status === 'code_sent' || status === 'code_checked' ? (
                    <div>
                        <div className='delete-account__code'>
                            <span>{i18n('Frontend.phone-confirm_confirmation_sent2').replace('%1', phone)}</span>
                            <span className='field_links'>
                                {countdown > 0 && (
                                    <span className='link__disabled'>{i18n('_AUTH_.code.send-again-link')}</span>
                                )}

                                {countdown === 0 && (
                                    <Link pseudo={true} onClick={this.sendCodeAgain}>
                                        {i18n('_AUTH_.code.send-again-link')}
                                    </Link>
                                )}

                                {Boolean(countdown > 0) && (
                                    <span className='countdown'> 0:{String(countdown).replace(/^(\d)$/, '0$1')}</span>
                                )}
                            </span>
                        </div>
                        <div className='delete-account__fields'>
                            <div className='delete-account__control-label'>
                                {i18n('ProfileDelete.code-field_label')}
                            </div>
                            <div className='delete-account__control-input_short'>
                                <Input
                                    id='code'
                                    value={form.code}
                                    hasClear={true}
                                    type='tel'
                                    placeholder={i18n('ProfileDelete.code-field_phone-placeholder')}
                                    name='code'
                                    size='l'
                                    onChange={this.onInputCode}
                                />

                                {Boolean(error.field === 'code') && (
                                    <div className='errors-block input-error error-block_code'>{error.message}</div>
                                )}
                            </div>
                        </div>
                    </div>
                ) : (
                    <div className='delete-account__fields'>
                        <div className='delete-account_phone-number'>
                            {i18n('ProfileJournal.profile.journal.personal-phone')}
                            <strong className='delete-account__masked-phone'>{phone}</strong>
                        </div>
                        <div className='delete-account_field-item'>
                            <div className='delete-account_field-item'>
                                <Button view='action' size='l' onClick={this.sendCode}>
                                    {i18n('ProfileDelete.button_send-code')}
                                </Button>
                            </div>
                            {Boolean(error.field === 'code') && (
                                <div className='errors-block input-error error-block_code'>{error.message}</div>
                            )}
                        </div>
                    </div>
                )}
            </div>
        );
    }
}

export default PhoneCheck;

PhoneCheck.propTypes = {
    phoneInfo: PropTypes.shape({
        method: PropTypes.string,
        status: PropTypes.string,
        phone: PropTypes.string,
        countdown: PropTypes.number
    }).isRequired,
    form: PropTypes.object,
    error: PropTypes.object,
    dispatch: PropTypes.func.isRequired
};
