import {UPDATE_ERROR, CHECK_STATUS, CONFIRM_PHONE_CODE, UPDATE_FORM_DATA, TOGGLE_MODAL, IS_FETCHING} from './actions';

export default function deleteAccount(state = {}, action) {
    switch (action.type) {
        case TOGGLE_MODAL: {
            return Object.assign({}, state, {
                isModalOpened: action.status
            });
        }
        case UPDATE_FORM_DATA: {
            const updatedForm = Object.assign({}, state.form, action.fields);

            return Object.assign({}, state, {
                form: updatedForm
            });
        }
        case UPDATE_ERROR: {
            return Object.assign({}, state, {
                error: action.errorData
            });
        }
        case CHECK_STATUS: {
            const confirmationInfo = Object.assign({}, state.confirmation);

            confirmationInfo.status = action.status;

            return Object.assign({}, state, {
                confirmation: confirmationInfo
            });
        }
        case CONFIRM_PHONE_CODE: {
            const phoneInfo = Object.assign({}, state.confirmation);

            phoneInfo.countdown = action.resend;

            return Object.assign({}, state, {
                confirmation: phoneInfo
            });
        }
        case IS_FETCHING: {
            return Object.assign({}, state, {
                isFetching: action.isFetching
            });
        }
        default:
            return state;
    }
}
