import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {setModalStatus, setFetchingStatus} from '@blocks/delete/actions';
import processError from '@blocks/delete/helpers/process_error';

export default function checkCaptcha() {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf,
            answer: state.deleteAccount.form.captcha
        };

        dispatch(setFetchingStatus(true));

        api.request('checkHuman', data)
            .done((response) => {
                if (response && response.status === 'ok') {
                    dispatch(setModalStatus(true));
                } else {
                    processError('captcha', 'captcha.captcheserver');
                }
            })
            .fail((error) => {
                const errorCode = error.errors && Array.isArray(error.errors) ? error.errors[0] : 'captcha.not_matched';

                dispatch(reloadCaptcha());
                dispatch(processError('captcha', errorCode));
            })
            .always(() => {
                dispatch(setFetchingStatus(false));
            });
    };
}
