import api from '../../api';
import {checkStatus, setModalStatus, setFetchingStatus} from '../actions';
import processError from '../helpers/process_error';
import metrics from '../../../../blocks/react-blocks/metrics';

export default function checkCode(code, method) {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf,
            code
        };

        dispatch(setFetchingStatus(true));

        api.request(`delete.account.confirm.${method}`, data)
            .done((response) => {
                if (response && response.status === 'ok') {
                    dispatch(checkStatus('code_checked'));
                    dispatch(setModalStatus(true));
                    metrics.send(['Подтверждение средства удаления', `Успешно введен код из ${method}`]);
                    metrics.send(['Подтверждение средства удаления', 'Показ попапа']);
                }
            })
            .fail((error) => {
                if (error.status === 'error' && error.code) {
                    dispatch(processError('code', error.code));
                } else {
                    dispatch(processError('code', ''));
                }
            })
            .always(() => {
                dispatch(setFetchingStatus(false));
            });
    };
}
