import api from '../../api';
import {saveActionForRepeat} from '../../common/actions';
import {setFetchingStatus, setModalStatus} from '../actions';
import processError from '../helpers/process_error';
import metrics from '../../metrics';

export default function deleteAccountCommit() {
    return (dispatch, getState) => {
        const {common: {isAppMode, csrf, track_id, retpath} = {}} = getState();
        const data = {
            csrf_token: csrf,
            track_id
        };

        const redirectLocation = `/auth/finish?track_id=${data.track_id}&retpath=${retpath}`;
        const redirectToApp = `/closewebview?status=success`;

        dispatch(saveActionForRepeat(deleteAccountCommit, data));
        dispatch(setFetchingStatus(true));

        api.request('delete.account.commit', data)
            .done((response) => {
                dispatch(setFetchingStatus(false));
                if (response.correct === false) {
                    dispatch(processError('captcha', 'captcha.not_matched'));
                    dispatch(setModalStatus(false));
                    return;
                }
                if (response && response.status === 'ok') {
                    metrics.send(['Удаление аккаунта прошло успешно, отправляем на финиш']);
                    isAppMode ? (window.location.href = redirectToApp) : (window.location.href = redirectLocation);
                }
            })
            .fail((error) => {
                const state = getState().deleteAccount;
                const {method} = state.confirmation;
                const isError = error && error.status === 'error';

                if (isError) {
                    const errorCode = (error) => {
                        let code = error.code || (error.errors && error.errors.code) || '';

                        if (Array.isArray(error.errors)) {
                            code = error.errors[0];
                        }
                        return code;
                    };

                    dispatch(processError(method, errorCode(error)));
                } else {
                    dispatch(processError());
                }
            });
    };
}
