import api from '@blocks/api';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
import {setModalStatus, setFetchingStatus, checkStatus} from '@blocks/delete/actions';
import processError from '@blocks/delete/helpers/process_error';
import metrics from '@blocks/metrics';

export default function questionCheck(answer) {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf,
            captcha: state.deleteAccount.form.captcha,
            answer
        };

        if (!answer) {
            dispatch(processError('question', 'answer.missingvalue'));
            return;
        }

        dispatch(setFetchingStatus(true));

        api.request('delete.account.check.question', data)
            .done((response) => {
                if (response && response.status === 'ok') {
                    if (response.correct === false) {
                        dispatch(processError('captcha', 'captcha.not_matched'));
                        return;
                    }
                    dispatch(checkStatus('confirmed'));
                    dispatch(setModalStatus(true));
                    metrics.send(['Подтверждение средства удаления', 'Успешно введен ответ на КВ']);
                    metrics.send(['Подтверждение средства удаления', 'Показ попапа']);
                }
            })
            .fail((error) => {
                const errorCode = error.code || error.error.error || '';
                const errorField = (error.error && error.error.field) || 'question';

                if (errorCode && errorCode === 'action.not_required') {
                    dispatch(setModalStatus(true));
                    return;
                }

                dispatch(reloadCaptcha());

                if (error.status === 'error') {
                    dispatch(processError(errorField, errorCode));
                } else {
                    dispatch(processError('question', ''));
                }
            })
            .always(() => {
                dispatch(setFetchingStatus(false));
            });
    };
}
