import api from '../../api';
import processError from '../helpers/process_error';
import updateFormFields from '../helpers/update_form_fields';
import {updateError, checkStatus, confirmPhoneCodeSend, setFetchingStatus} from '../actions';

export default function sendConfirmation(form, method) {
    return (dispatch, getState) => {
        const state = getState();
        const data = {
            track_id: state.common.track_id,
            csrf_token: state.common.csrf,
            captcha: form.captcha
        };

        data[method] = form[method];

        if (state.deleteAccount.confirmation.status === 'skip_captcha') {
            data.captcha = 'skip';
        }

        dispatch(setFetchingStatus(true));

        api.request(`delete.account.send.${method}`, data)
            .done((response) => {
                if (response.status === 'ok') {
                    if (response.correct === false) {
                        dispatch(processError('captcha', 'captcha.not_matched'));
                        return;
                    }
                    dispatch(updateError({field: '', message: ''}));
                    dispatch(updateFormFields({code: ''}));
                    dispatch(checkStatus('code_sent'));
                    if (response.timeout) {
                        dispatch(confirmPhoneCodeSend(response.timeout));
                    }
                }

                if (response.status === 'error') {
                    dispatch(processError(response.error.field, response.error.error));
                }
            })
            .fail((error) => {
                if (error && error.status === 'error') {
                    const errorObj = error.error;
                    const errorCode = error.code;

                    if (errorObj) {
                        dispatch(processError(errorObj.field, errorObj.error));
                    }
                    if (errorCode) {
                        dispatch(processError(method, errorCode));
                    }
                } else {
                    dispatch(processError());
                }
            })
            .always(() => {
                dispatch(setFetchingStatus(false));
            });
    };
}
