import React from 'react';
import _get from 'lodash/get';

export const context = {
    values: {},
    setItem(key, value) {
        this.values[key] = value;
    },
    removeItem(key) {
        if (this.hasOwnProperty(key)) {
            delete this.values[key];
        }
    }
};

export default function withContext(Component) {
    return function WithContext(props) {
        return <Component {...props} context={context.values} />;
    };
}

export function withUpdater(Component, editKeys, pathToEdit, isUpdateRequired) {
    return class withUpdate extends React.Component {
        shouldComponentUpdate() {
            if (!pathToEdit || !editKeys || isUpdateRequired) {
                return true;
            }

            const rerender = context.values.rerender;
            const edit = _get(this.props, pathToEdit, '');

            let equal;

            try {
                equal = typeof editKeys === 'string' ? editKeys === rerender : editKeys.indexOf(rerender) !== -1;
            } catch (e) {
                return true;
            }

            return rerender === 'all' || ((equal || Boolean(edit)) && rerender !== edit);
        }

        render() {
            return <Component {...this.props} context={context.values} />;
        }
    };
}
