import React from 'react';

export default function withMethods(Component, method, data) {
    return class WithMethods extends React.Component {
        static handleMethod(d) {
            return () => {
                method(d);
            };
        }

        constructor(props) {
            super(props);

            this.methods = {};

            for (const key in data) {
                if (data.hasOwnProperty(key)) {
                    this.methods[key] = WithMethods.handleMethod(data[key]);
                }
            }
        }

        render() {
            return <Component methods={this.methods} {...this.props} />;
        }
    };
}
