import React from 'react';

import ReturnToService from '@components/ReturnToService/ReturnToService.jsx';

/* eslint-disable react/prop-types */

export default function withReturnToService(Component, className, returnPath = '/profile') {
    return function WithReturnToService(props) {
        return (
            <div className={className}>
                <ReturnToService pathTo={returnPath} retpath={(props.common || {}).retpath} />
                <Component {...props} />
            </div>
        );
    };
}
