import Metrika from '@old-blocks/metrics/Metrika';
import {getProcessName, isRegisterProcess} from '@blocks/UserEntryFlow/utils';
import {ENTRY_RESTORE_NEOPHONISH_PROCESS, ENTRY_RESTORE_PROCESS} from '@blocks/UserEntryFlow/processes';

const metrika = {
    initialized: false,
    isAm: false,
    init(store) {
        const state = store.getState();
        const {am = {}, metrics: {experiments} = {}} = state;
        const data = document.querySelector('body').dataset || {};
        const {metricsId, version, userType, origin} = data;
        const params = {
            version,
            userType,
            origin
        };

        this.headerMetrics = [state.metrics.header];

        if (am.isAm) {
            this.headerMetrics.unshift('WebAM');

            const amParams = {
                mode: am.mode,
                deviceId: am.deviceId,
                appId: am.appId
            };

            for (const key in amParams) {
                if (amParams[key]) {
                    params[key] = amParams[key];
                }
            }

            if (origin === 'null') {
                params.origin = am.appId;
            }
        }

        Metrika.init(metricsId, experiments, params);
        this.initialized = true;
    },

    setHeader(header) {
        this.headerMetrics = [header];
    },

    send(params) {
        if (this.initialized) {
            // didMount выстреливает начиная с самого глубокого компонента и заканчивая первым,
            // в котором может быть переопределение загловка.
            // Чтобы предотвартить неверные записи в метрику, делаем их асинхронно
            setTimeout(() => {
                Metrika.count(this.headerMetrics.concat(params));
            }, 0);
        }
    },

    goal(target, params) {
        if (this.initialized) {
            Metrika.reachGoal(target, params);
        }
    }
};

export default metrika;

export const setMetricsHeader = () => (dispatch, getState) => {
    const state = getState();
    const process = getProcessName(state);
    const {signup = {}, metrics = {}, userEntryFlow = {}} = state;
    const {mode: signUpMode} = signup;
    const {isRegAfterAuthStart} = userEntryFlow;
    const {header} = metrics;

    if (isRegAfterAuthStart) {
        return metrika.setHeader('Авторизация');
    }

    if (process === ENTRY_RESTORE_PROCESS) {
        metrika.setHeader('Восстановление логина');
        metrika.send('Показ восстановления');
        return;
    }

    if (process === ENTRY_RESTORE_NEOPHONISH_PROCESS) {
        metrika.setHeader('Восстановление логина для неофониша');
        metrika.send('Показ восстановления для неофониша');
        return;
    }

    if (isRegisterProcess(process)) {
        metrika.setHeader(`Регистрация ${signUpMode}`);
        metrika.send(`Показ регистрации ${signUpMode}`);
        return;
    }

    metrika.setHeader(header);
};
