import React from 'react';
import PropTypes from 'prop-types';

const BadretpathError = ({code, badretpath, errorEncoded, tld}) => {
    const titleTextStr = badretpath
        ? i18n('Errors.ModeError.redirect_short').replace('%url', badretpath)
        : i18n('Errors.ModeError.redirect_short_updated');
    const textStr = badretpath
        ? i18n('Errors.ModeError.redirect_full').replace(/%url%/gi, badretpath)
        : i18n('Errors.ModeError.redirect_full_updated');
    const fullDescriptionText = textStr
        .replace('%subj%', `?subject=Error code ${errorEncoded}`)
        .replace('%error_text%', errorEncoded);
    const aboutRegistrationText = i18n('Errors.ModeError.register_text').replace(/%domain%/gi, tld);

    if (code === 'badretpath') {
        return (
            <div className='mode-error__block'>
                <h1 className='mode-error__title' dangerouslySetInnerHTML={{__html: titleTextStr}} />
                <div className='mode-error__description'>
                    <div dangerouslySetInnerHTML={{__html: fullDescriptionText}} />
                    <p dangerouslySetInnerHTML={{__html: aboutRegistrationText}} />
                </div>
            </div>
        );
    }

    return null;
};

export default BadretpathError;

BadretpathError.propTypes = {
    code: PropTypes.string.isRequired,
    errorEncoded: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired,
    badretpath: PropTypes.string
};
