import React from 'react';
import PropTypes from 'prop-types';

const InternalError = ({code, errorEncoded, tld}) => {
    const supportMail = `passerror@support.yandex.${tld}`;

    if (code === 'internal') {
        return (
            <div className='mode-error__block'>
                <h1 className='mode-error__title'>{i18n('Errors.AutoLogin.badcall')}</h1>
                <div className='mode-error__description'>
                    <p>{i18n('Errors.ModeError.try_again')}</p>
                    <p>
                        {i18n('Errors.ModeError.error_repeat')}&nbsp;
                        <a href={`mailto:${supportMail}?subject=Error code ${errorEncoded}`}>{supportMail}</a>
                    </p>
                    <p>
                        <span dangerouslySetInnerHTML={{__html: i18n('Errors.ModeError.support_send')}} />
                        <em className='mode-error__info'> {errorEncoded}</em>
                    </p>
                </div>
            </div>
        );
    }

    return null;
};

export default InternalError;

InternalError.propTypes = {
    code: PropTypes.string.isRequired,
    errorEncoded: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired
};
