import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import InternalError from './InternalError.jsx';
import NojsError from './NojsError.jsx';
import NoCookieError from './NoCookieError.jsx';
import BadretpathError from './BadretpathError.jsx';

class ModeError extends Component {
    static mapStateToProps(state) {
        const {
            error,
            settings: {tld}
        } = state;

        return {
            error,
            tld
        };
    }

    render() {
        const {tld, error} = this.props;
        const {code, errorEncoded, badretpath} = error;

        return (
            <div className='mode-error__wrapper'>
                <h2>{i18n('Errors.ErrorsTexts.ppinvemail')}</h2>
                <InternalError code={code} errorEncoded={errorEncoded} tld={tld} />
                <NojsError code={code} />
                <NoCookieError code={code} />
                <BadretpathError code={code} tld={tld} errorEncoded={errorEncoded} badretpath={badretpath} />
            </div>
        );
    }
}

export default connect(ModeError.mapStateToProps)(ModeError);

ModeError.propTypes = {
    tld: PropTypes.string.isRequired,
    error: PropTypes.object.isRequired
};
