import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

class ModeErrorHeader extends Component {
    static mapStateToProps(state) {
        const {
            settings: {tld}
        } = state;

        return {
            tld
        };
    }

    render() {
        const {tld} = this.props;
        const isRu = ['ru', 'ua', 'kz', 'by'].includes(tld);
        const logoLang = isRu ? 'ru' : 'com';

        return (
            <div className='mode-error__header'>
                <a href='/profile' title={i18n('Frontend.passport.title')}>
                    <span className={`mode-error__header-logo mode-error__header-logo_${logoLang}`}>
                        {i18n('Frontend.passport.title')}
                    </span>
                </a>
            </div>
        );
    }
}

export default connect(ModeErrorHeader.mapStateToProps)(ModeErrorHeader);

ModeErrorHeader.propTypes = {
    tld: PropTypes.string
};
