import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {countAppPasswords} from '../../app_passwords';
import {TwoFA, AppPasswords} from '../../';
import {Devices} from '../devices/devices.jsx';
import metrics from '../../metrics';

export class Access extends Component {
    sendMetrics(msg) {
        metrics.send(['Управление доступом', msg]);
    }

    componentDidMount() {
        const {dispatch, access} = this.props;

        if (access.isAppPasswordsEnabled) {
            dispatch(countAppPasswords());
        }
    }

    render() {
        const {dispatch, settings, access, common, appPasswords} = this.props;
        const {is2faEnabled, featureHint, isAppPasswordsEnabled, isSocialchik} = access;
        const isTouch = settings.ua.isTouch;
        const passwordStrength = access.passwordInfo.strength;

        return (
            <div className='section access'>
                <span className='section-icon' />
                <div className='section-head'>
                    <h2 className='section-title'>{i18n('Profile.access.title')}</h2>
                </div>
                <Devices />
                <AppPasswords
                    isTouch={isTouch}
                    edit={common.edit}
                    settings={settings}
                    is2faEnabled={is2faEnabled}
                    passwordStrength={passwordStrength}
                    isSocialchik={isSocialchik}
                    featureHint={featureHint}
                    isEnabled={isAppPasswordsEnabled}
                    appPasswords={appPasswords}
                    retpath={common.retpath}
                    sendMetrics={this.sendMetrics}
                    dispatch={dispatch}
                />
                <TwoFA
                    isTouch={isTouch}
                    settings={settings}
                    passwordStrength={passwordStrength}
                    featureHint={featureHint}
                    setEditMode={common.edit}
                    is2faEnabled={is2faEnabled}
                    canChangePassword={common.canChangePassword}
                    sendMetrics={this.sendMetrics}
                    isEnabled={is2faEnabled}
                    dispatch={dispatch}
                />
            </div>
        );
    }
}

Access.propTypes = {
    access: PropTypes.shape({
        featureHint: PropTypes.string,
        is2faEnabled: PropTypes.bool,
        isSocialchik: PropTypes.bool,
        isAppPasswordsEnabled: PropTypes.bool,
        passwordInfo: PropTypes.object
    }),
    dispatch: PropTypes.func,
    common: PropTypes.object,
    settings: PropTypes.object,
    appPasswords: PropTypes.object
};
