import {deleteEditAddressErrors, setEditAddressErrors} from './';

const ADDRESS_REQUIRED_FIELDS = ['country', 'city', 'building'];

export function checkRequiredFields(address = {}, id) {
    return (dispatch) => {
        dispatch(deleteEditAddressErrors(id));

        for (let index = 0; index < ADDRESS_REQUIRED_FIELDS.length; index++) {
            if (!address[ADDRESS_REQUIRED_FIELDS[index]]) {
                if (ADDRESS_REQUIRED_FIELDS[index] === 'building') {
                    dispatch(setEditAddressErrors(id, ['incorrect-address']));
                    break;
                }

                dispatch(setEditAddressErrors(id, [`empty.${ADDRESS_REQUIRED_FIELDS[index]}`]));
                break;
            }
        }
    };
}
