import {clearEditState, deleteAddressAction, setAddressesErrors, setAddressesSavingProgressState} from './';
import api from '../../../api';
import {editAddressLine} from './index';

export function deleteAddress(id, isDeliveryAddress) {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            addresses: {delivery, defaultDelivery}
        } = getState();

        dispatch(setAddressesSavingProgressState(true));
        api.request('delete.addresses', {id, csrf}, {abortPrevious: true})
            .done((response) => {
                dispatch(setAddressesSavingProgressState(false));

                if (response.status === 'ok') {
                    if (isDeliveryAddress && delivery.length === 1) {
                        dispatch(editAddressLine('', defaultDelivery));
                    }

                    dispatch(deleteAddressAction(id, isDeliveryAddress));
                    dispatch(clearEditState(id));
                }
            })
            .fail((error) => {
                dispatch(setAddressesSavingProgressState(false));
                dispatch(setAddressesErrors(error));
            });
    };
}
