import api from '../../../api';
import {setAddresses, setAddressesProgressState} from './';

export function getAddresses() {
    return (dispatch, getState) => {
        const {
            common: {csrf}
        } = getState();

        dispatch(setAddressesProgressState(true));

        api.request('get.addresses', {csrf})
            .done((response) => {
                dispatch(setAddresses(response));
                dispatch(setAddressesProgressState(false));
            })
            .fail(() => {
                dispatch(setAddressesProgressState(false));
            });
    };
}
