import {getLocale} from '../../../common';
import {saveAddressesFromGeoCoder} from './save_addresses_from_geo_coder';
import {checkRequiredFields} from './check_required_fields';
import {getLocationByGeoCode} from './get_location_by_geo_code';
import {
    DEFAULT_DELIVERY_ADDRESS_ID,
    NOT_FOUND,
    setEditAddressErrors,
    setGeoLocationUpdateState,
    createAddressId,
    setGeoLocation
} from './';

export function getGeoLocation(id, isDeliveryAddress) {
    return (dispatch, getState) => {
        const addressID = id !== DEFAULT_DELIVERY_ADDRESS_ID ? id : createAddressId();
        const {addresses = {}, settings = {}, common = {}} = getState();
        const {isGeoLocationAvailable = false} = addresses;
        const {language = 'ru', tld = 'ru'} = settings;
        const {csrf} = common;

        if (!isGeoLocationAvailable && !window.navigator.geolocation) {
            return;
        }

        dispatch(setGeoLocationUpdateState(true, id));
        window.navigator.geolocation.getCurrentPosition(
            (position) => {
                const {coords} = position;
                const {latitude, longitude} = coords;

                getLocationByGeoCode(`${longitude},${latitude}`, getLocale(language, tld), isDeliveryAddress, csrf)
                    .done((response) => {
                        const address = response.body || {};

                        if (isDeliveryAddress) {
                            checkRequiredFields(address, addressID)(dispatch);
                        }

                        dispatch(setGeoLocation(Object.assign({}, address, {latitude, longitude})));
                        saveAddressesFromGeoCoder(address, addressID, isDeliveryAddress)(dispatch);
                    })
                    .fail((error) => {
                        const {errors = []} = error;

                        dispatch(setGeoLocationUpdateState(false, null));

                        if (errors.indexOf('geocoder.empty') !== NOT_FOUND) {
                            dispatch(setEditAddressErrors(id, ['geocoder.empty']));
                        }
                    });
            },
            () => {
                dispatch(setGeoLocationUpdateState(false, null));
            },
            {enableHighAccuracy: false, timeout: 20000, maximumAge: 1000}
        );
    };
}
