import {getLocale} from '../../../common';
import {setAddressesSuggest} from './';

export function getSuggest(entry) {
    return (dispatch, getContext) => {
        const {settings = {}} = getContext();
        const {language = 'ru', tld = 'ru'} = settings;

        $.getJSON('https://suggest-maps.yandex.net/suggest-geo?callback=?', {
            search_type: 'addr',
            v: 7, // версия выдачи
            n: 5, // количество элементов
            fullpath: 1,
            lang: getLocale(language, tld),
            part: entry
        }).done(function(response) {
            dispatch(setAddressesSuggest(response && response.results));
        });
    };
}
