export const SET_ADDRESSES = 'SET_ADDRESSES';
export const SET_ADDRESS = 'SET_ADDRESS';
export const SET_ADDRESSES_PROGRESS_STATE = 'SET_ADDRESSES_PROGRESS_STATE';
export const SET_ADDRESSES_SAVING_PROGRESS_STATE = 'SET_ADDRESSES_SAVING_PROGRESS_STATE';
export const SET_ADDRESSES_EDIT_MODE = 'SET_ADDRESSES_EDIT_MODE';
export const SET_ADDRESSES_SUGGEST = 'SET_ADDRESSES_SUGGEST';
export const SET_ADDRESSES_CONTEXT = 'SET_ADDRESSES_CONTEXT';
export const SET_EDIT_STATE = 'SET_EDIT_STATE';
export const CLEAR_EDIT_STATE = 'CLEAR_EDIT_STATE';
export const SET_ADDRESSES_ERRORS = 'SET_ADDRESSES_ERRORS';
export const SET_ADDRESSES_UPDATE_STATE = 'SET_ADDRESSES_UPDATE_STATE';
export const SET_ADD_DELIVERY_ADDRESS_MODE = 'SET_ADD_DELIVERY_ADDRESS_MODE';
export const DELETE_ADDRESS = 'DELETE_ADDRESS';
export const SET_GEO_LOCATION_STATUS = 'SET_GEO_LOCATION_STATUS';
export const SET_GEO_LOCATION = 'SET_GEO_LOCATION';
export const SET_GEO_LOCATION_UPDATE_STATE = 'SET_GEO_LOCATION_UPDATE_STATE';
export const CLEAR_ADDRESSES_STATE = 'CLEAR_ADDRESSES_STATE';
export const SET_EDIT_ADDRESS_ERRORS = 'SET_EDIT_ADDRESS_ERRORS';
export const DELETE_EDIT_ADDRESS_ERRORS = 'DELETE_EDIT_ADDRESS_ERRORS';
export const EDIT_ADDRESS_LINE = 'EDIT_ADDRESS_LINE';
export const EDIT_ADDRESS_FLAT = 'EDIT_ADDRESS_FLAT';

export const ADDRESSES_LINK = '/profile/address';
export const EDIT_MODE_ADDRESSES = 'EDIT_MODE_ADDRESSES';
export const EDIT_MODE_DELIVERY_ADDRESSES = 'EDIT_MODE_DELIVERY_ADDRESSES';
export const DEFAULT_DELIVERY_ADDRESS_ID = 'defaultDelivery';
export const ADDRESS_TYPES = {
    home: i18n('Profile.addresses.type.home'),
    work: i18n('Profile.addresses.type.work'),
    delivery: i18n('Profile.addresses.type.delivery')
};
export const ADDRESSES_GOAL_PREFIX = 'profile_page_addresses';
export const NOT_FOUND = -1;
const ID_MULTIPLIER = 1000000000000;

export function setAddresses(addresses) {
    return {
        type: SET_ADDRESSES,
        addresses
    };
}

export function setAddress(address, isDeliveryAddress) {
    return {
        type: SET_ADDRESS,
        address,
        isDeliveryAddress
    };
}

export function editAddressLine(editedAddressLine, address) {
    return {
        type: EDIT_ADDRESS_LINE,
        editedAddressLine,
        address
    };
}

export function editAddressFlat(editedAddressFlat, address) {
    return {
        type: EDIT_ADDRESS_FLAT,
        editedAddressFlat,
        address
    };
}

export function setAddressesEditMode(mode) {
    return {
        type: SET_ADDRESSES_EDIT_MODE,
        mode
    };
}

export function setAddressesProgressState(progress) {
    return {
        type: SET_ADDRESSES_PROGRESS_STATE,
        progress
    };
}

export function setAddressesSavingProgressState(progress) {
    return {
        type: SET_ADDRESSES_SAVING_PROGRESS_STATE,
        progress
    };
}

export function setAddressesSuggest(suggest) {
    return {
        type: SET_ADDRESSES_SUGGEST,
        suggest
    };
}

export function setAddressesContext(context) {
    return {
        type: SET_ADDRESSES_CONTEXT,
        context
    };
}

export function setEditState(id) {
    return {
        type: SET_EDIT_STATE,
        id
    };
}

export function clearEditState(id) {
    return {
        type: CLEAR_EDIT_STATE,
        id
    };
}

export function setAddressesErrors(errors) {
    return {
        type: SET_ADDRESSES_ERRORS,
        errors
    };
}

export function setAddressesUpdateState(state) {
    return {
        type: SET_ADDRESSES_UPDATE_STATE,
        state
    };
}

export function setAddDeliveryAddressMode(mode) {
    return {
        type: SET_ADD_DELIVERY_ADDRESS_MODE,
        mode
    };
}

export function deleteAddressAction(id, isDeliveryAddress) {
    return {
        type: DELETE_ADDRESS,
        id,
        isDeliveryAddress
    };
}

export function setGeoLocationStatus(isAvailable) {
    return {
        type: SET_GEO_LOCATION_STATUS,
        isAvailable
    };
}

export function setGeoLocation(geolocation) {
    return {
        type: SET_GEO_LOCATION,
        geolocation
    };
}

export function setGeoLocationUpdateState(progress, id) {
    return {
        type: SET_GEO_LOCATION_UPDATE_STATE,
        progress,
        id
    };
}

export function clearAddressesState() {
    return {
        type: CLEAR_ADDRESSES_STATE
    };
}

export function setEditAddressErrors(id, errors) {
    return {
        type: SET_EDIT_ADDRESS_ERRORS,
        id,
        errors
    };
}

export function deleteEditAddressErrors(id) {
    return {
        type: DELETE_EDIT_ADDRESS_ERRORS,
        id
    };
}

export function createAddressId() {
    return String(parseInt(Math.random() * ID_MULTIPLIER, 10));
}
