import {deleteEditAddressErrors, setGeoLocationUpdateState} from './';
import {checkRequiredFields} from './check_required_fields';
import {saveAddressesFromGeoCoder} from './save_addresses_from_geo_coder';
import {getLocationByGeoCode} from './get_location_by_geo_code';
import {getLocale} from '../../../common';

export function parseAddress(address, isDeliveryAddress) {
    return (dispatch, getContext) => {
        const {addressLine, id} = address;
        const {settings = {}, common = {}} = getContext();
        const {language = 'ru', tld = 'ru'} = settings;
        const {csrf} = common;

        if (!addressLine) {
            return;
        }

        dispatch(setGeoLocationUpdateState(true, id));

        getLocationByGeoCode(addressLine, getLocale(language, tld), true, csrf)
            .done((response) => {
                const newAddress = response.body || {};

                dispatch(deleteEditAddressErrors(id));
                checkRequiredFields(newAddress, id)(dispatch);
                saveAddressesFromGeoCoder(newAddress, id, isDeliveryAddress)(dispatch);
            })
            .fail(() => {
                dispatch(setGeoLocationUpdateState(false, null));
            });
    };
}
