import {setEditMode} from '../../../common/actions';
import {getAddresses} from './get_addresses';
import {
    clearAddressesState,
    setAddressesSavingProgressState,
    setAddressesErrors,
    clearEditState,
    setAddressesUpdateState,
    NOT_FOUND
} from './';
import api from '../../../api';

export function saveAddresses() {
    return (dispatch, getState) => {
        const {addresses = {}, common = {}} = getState();
        const {delivery = [], editedFields = {}} = addresses;
        const {csrf} = common;
        const parsedAddresses = [];

        for (const addressID in editedFields) {
            let address;

            let parsedAddress;

            if (['home', 'work'].indexOf(addressID) === NOT_FOUND) {
                const index = delivery.findIndex((item) => item.id === addressID);

                address = delivery[index];

                if (address) {
                    parsedAddress = Object.assign({}, address, {flat: address.editedAddressFlat});
                }
            } else {
                address = addresses[addressID];
                parsedAddress = Object.assign({}, address);
            }

            if (parsedAddress) {
                delete parsedAddress.editedAddressLine;
                delete parsedAddress.editedAddressFlat;

                parsedAddresses.push(parsedAddress);
            }
        }

        dispatch(setAddressesSavingProgressState(true));
        api.request(
            'save.addresses',
            {
                addresses: JSON.stringify(parsedAddresses),
                csrf
            },
            {abortPrevious: true}
        )
            .done((response) => {
                dispatch(setAddressesSavingProgressState(false));

                if (response.status === 'ok') {
                    dispatch(setAddressesUpdateState(true));
                    dispatch(clearEditState());
                    dispatch(setEditMode(''));
                    dispatch(clearAddressesState());
                }
            })
            .fail((error) => {
                dispatch(setAddressesSavingProgressState(false));
                dispatch(setAddressesErrors(error));
            })
            .always(() => {
                // https://st.yandex-team.ru/PASSP-16757
                // При сохранении адреса нельзя тутже идти в DataSync, иначе он вернет старый адрес
                setTimeout(function() {
                    dispatch(getAddresses());
                }, 1500);
            });
    };
}
