import {setAddressHelper} from './set_address_helper';
import {setAddDeliveryAddressMode, setEditState, setGeoLocationUpdateState} from './';

export function saveAddressesFromGeoCoder(address, addressID, isDeliveryAddress) {
    return (dispatch) => {
        dispatch(setAddressHelper(Object.assign({}, address, {id: addressID}), isDeliveryAddress));
        dispatch(setEditState(addressID));
        dispatch(setGeoLocationUpdateState(false, null));

        if (isDeliveryAddress) {
            dispatch(setAddDeliveryAddressMode(false));
        }
    };
}
