import React from 'react';
import PropTypes from 'prop-types';

import {Link as LegoLink} from '@components/Link';

import Link from '@blocks/morda/components/link/link.jsx';
import {ADDRESSES_LINK, ADDRESS_TYPES} from '@blocks/morda/addresses/actions';
import {sendMetrics, setEditMode} from './service';

class Address extends React.Component {
    constructor(props) {
        super(props);

        this.sendMetrics = sendMetrics.bind(this);
        this.setEditMode = setEditMode.bind(this);
    }

    render() {
        const {address, addIfEmpty, isPhone} = this.props;

        return (
            <div className='address'>
                <span className='address-type'>{`${ADDRESS_TYPES[address.id] || ADDRESS_TYPES.delivery}: `}</span>

                {address.addressLineShort || address.addressLine}

                {!address.addressLineShort && addIfEmpty && (
                    <span onMouseDown={this.sendMetrics} data-t={`address-widget:add-${address.id}`}>
                        {isPhone ? (
                            <Link url={ADDRESSES_LINK}>{i18n('Profile.addresses.add')}</Link>
                        ) : (
                            <LegoLink pseudo={true} onClick={this.setEditMode}>
                                {i18n('Profile.addresses.add')}
                            </LegoLink>
                        )}
                    </span>
                )}
            </div>
        );
    }
}

Address.propTypes = {
    isPhone: PropTypes.bool,
    addIfEmpty: PropTypes.bool,
    dispatch: PropTypes.func,
    address: PropTypes.shape({
        id: PropTypes.string,
        title: PropTypes.string,
        addressLine: PropTypes.string,
        addressLineShort: PropTypes.string,
        longitude: PropTypes.number,
        latitude: PropTypes.number
    })
};

export default Address;
