import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import Map from '@blocks/morda/components/map/map.jsx';
import AddressesTypeToggle from '@blocks/morda/addresses/components/addresses_type_toggle/index.jsx';
import AddressesEditControl from '@blocks/morda/addresses/components/addresses_edit_control/index.jsx';

import {EDIT_MODE_ADDRESSES, EDIT_MODE_DELIVERY_ADDRESSES} from '@blocks/morda/addresses/actions/index';

import {setEditMode} from './service';
import {getAddresses} from '@blocks/morda/addresses/actions/get_addresses';

class AddressesControl extends React.Component {
    constructor(props) {
        super(props);

        this.displayName = 'AddressesControl';
        this.setEditMode = setEditMode.bind(this);
    }

    componentDidMount() {
        if (!this.props.modal) {
            this.props.dispatch(getAddresses());
        }
    }

    render() {
        const {modal, settings = {}, dispatch, addresses = {}, common} = this.props;
        const {tld} = settings;
        const {home = {}, work = {}, mode} = addresses;
        const mapAddrs = [];

        if (home.longitude) {
            mapAddrs.push(home);
        }

        if (work.longitude) {
            mapAddrs.push(work);
        }

        return (
            <div
                className={classnames('p-control-form', {
                    'p-control-modal': modal,
                    'map-modal_opened':
                        common.edit === EDIT_MODE_ADDRESSES || common.edit === EDIT_MODE_DELIVERY_ADDRESSES
                })}
            >
                <div className='section-head'>
                    <h2 className='section-title'>{i18n('Profile.addresses.title.short')}</h2>
                    <div className='section-info'>{i18n('Profile.addresses.subtitle')}</div>
                </div>

                {tld === 'ru' && <AddressesTypeToggle mode={mode} dispatch={dispatch} />}

                {mode !== EDIT_MODE_DELIVERY_ADDRESSES && (
                    <Map
                        className='addresses-control-map'
                        points={mapAddrs}
                        settings={settings}
                        width={628}
                        height={210}
                    />
                )}

                <AddressesEditControl
                    modal={modal}
                    addresses={addresses}
                    settings={settings}
                    common={common}
                    dispatch={dispatch}
                />
            </div>
        );
    }
}

AddressesControl.propTypes = {
    settings: PropTypes.object,
    dispatch: PropTypes.func,
    modal: PropTypes.bool,
    addresses: PropTypes.shape({
        delivery: PropTypes.array,
        work: PropTypes.object,
        home: PropTypes.object,
        mode: PropTypes.string,
        suggest: PropTypes.array,
        context: PropTypes.string,
        editedFields: PropTypes.object,
        isUpdated: PropTypes.bool,
        savingProgress: PropTypes.bool,
        addDeliveryAddress: PropTypes.bool
    }),
    common: PropTypes.object
};

export default AddressesControl;
