import {saveAddresses as saveAddressesAction} from '../../actions/save_addresses';
import metrics from '../../../../metrics';
import {
    ADDRESSES_GOAL_PREFIX,
    EDIT_MODE_DELIVERY_ADDRESSES,
    setAddDeliveryAddressMode as setAddDeliveryAddressModeAction,
    setAddressesUpdateState,
    setAddressesEditMode,
    editAddressLine
} from '../../actions';
import {clearState} from '../../actions/clear_state';
import util from '../../../../utils';
import {push} from 'connected-react-router';
import isUndefined from 'lodash/isUndefined';

export function closeAddressesControl(event, silent) {
    const {dispatch} = this.props;

    dispatch(clearState());

    if (!silent) {
        metrics.goal(`${ADDRESSES_GOAL_PREFIX}_close`);
    }
}

export function onSubmit(event) {
    event.preventDefault();
    this.saveAddresses();
}

export function saveAddresses() {
    const {dispatch, addresses} = this.props;
    const {editErrors = {}, mode} = addresses;

    if (Object.keys(editErrors).length) {
        if (mode !== EDIT_MODE_DELIVERY_ADDRESSES) {
            dispatch(setAddressesEditMode(EDIT_MODE_DELIVERY_ADDRESSES));
        }

        return;
    }

    dispatch(saveAddressesAction());
    metrics.goal(`${ADDRESSES_GOAL_PREFIX}_save`);
}

export function setAddDeliveryAddressMode() {
    const {
        dispatch,
        addresses: {geoLocationUpdateState = {}, defaultDelivery}
    } = this.props;

    if (geoLocationUpdateState.progress) {
        return;
    }

    dispatch(editAddressLine('', defaultDelivery));
    dispatch(setAddDeliveryAddressModeAction(true));
}

export function handleAddressUpdate() {
    const {dispatch, modal, common = {}} = this.props;
    const {retpath} = common;

    dispatch(setAddressesUpdateState(false));

    if (isUndefined(window)) {
        return;
    }

    if (window.location.href !== retpath) {
        if (util.isThirdPartyUrl(retpath)) {
            window.location = retpath;
            return;
        } else if (retpath) {
            dispatch(push(retpath));
        }
    }

    if (!modal) {
        dispatch(push('/profile'));
    }
}
