import {
    DEFAULT_DELIVERY_ADDRESS_ID,
    NOT_FOUND,
    setAddDeliveryAddressMode,
    setAddressesContext,
    setAddressesSuggest,
    createAddressId,
    deleteEditAddressErrors,
    setEditState,
    editAddressLine,
    editAddressFlat,
    clearEditState
} from '../../actions';
import {deleteAddress as deleteAddressAction} from '../../actions/delete_address';
import {parseAddress} from '../../actions/parse_address';
import {setAddressHelper} from '../../actions/set_address_helper';
import {getSuggest as getSuggestAction} from '../../actions/get_suggest';
import {getGeoLocation as getGeoLocationAction} from '../../actions/get_geo_location';

export const ERRORS = {
    internal: i18n('Profile.addresses.errors.internal'),
    'empty.country': i18n('Profile.addresses.errors.empty.country'),
    'empty.city': i18n('Profile.addresses.errors.empty.city'),
    'empty.street': i18n('Profile.addresses.errors.empty.street'),
    'empty.building': i18n('Profile.addresses.errors.empty.building'),
    'incorrect-address': i18n('Profile.addresses.errors.incorrect-address'),
    'geocoder.empty': i18n('Profile.addresses.errors.geocoder.empty')
};

export function getSuggest(value) {
    const {dispatch} = this.props;

    dispatch(getSuggestAction(value));
}

export function setContext() {
    const {dispatch, context, id} = this.props;

    if (id !== context) {
        dispatch(setAddressesSuggest([]));
        dispatch(setAddressesContext(id));
    }
}

export function clearContext() {
    const {dispatch} = this.props;

    setTimeout(() => {
        dispatch(setAddressesSuggest([]));
        dispatch(setAddressesContext(''));
    }, 300);
}

export function getOptions() {
    const {suggest = []} = this.props;

    return suggest.map((item) => {
        let fullAddress;

        if (item.desc) {
            fullAddress = `${item.desc
                .split(', ')
                .reverse()
                .join(', ')}, ${item.name}`;
        } else {
            fullAddress = item.name;
        }

        return {
            content: fullAddress,
            value: `${fullAddress}|${item.name}|${item.lat}|${item.lon}`
        };
    });
}

export function isDeliveryAddress() {
    const {id} = this.props;

    return id !== 'home' && id !== 'work';
}

export function getSuggestValue(event = {}) {
    const {target = {}} = event;
    const {value} = target;
    const {dispatch, id} = this.props;
    const addressValue = (value && value.split('|')) || [];
    const isDelivery = this.isDeliveryAddress();
    const address = {id};

    let fields = ['addressLine'];

    if (isDelivery) {
        fields.push('flat');
    } else {
        fields = fields.concat(['addressLineShort', 'latitude', 'longitude']);
    }

    fields.forEach((fieldName, index) => {
        if (fieldName === 'latitude' || fieldName === 'longitude') {
            address[fieldName] = Number(addressValue[index]);
        } else if (fieldName === 'flat') {
            address[fieldName] = this.props.address.editedAddressFlat;
        } else {
            address[fieldName] = addressValue[index];
        }
    });

    if (id === DEFAULT_DELIVERY_ADDRESS_ID) {
        address.id = createAddressId();
        dispatch(setAddDeliveryAddressMode(false));
    } else {
        this.addressLine && this.addressLine.focus();
    }

    if (isDelivery) {
        dispatch(parseAddress(address, isDelivery));
    } else {
        dispatch(setEditState(address.id));
        dispatch(setAddressHelper(address, isDelivery));
    }
}

export function deleteAddress() {
    const {dispatch, id} = this.props;

    dispatch(deleteAddressAction(id, this.isDeliveryAddress()));
}

export function updatedDeliveryAddress(event) {
    const {target = {}} = event;
    const {value} = target;
    const {dispatch, address = {}, id} = this.props;

    dispatch(editAddressFlat(value, address));

    if (id !== DEFAULT_DELIVERY_ADDRESS_ID && value !== address.flat) {
        const newAddress = Object.assign({}, address, {flat: value, editedAddressFlat: value});

        dispatch(setAddressHelper(newAddress, true));
        dispatch(setEditState(address.id));
    }
}

export function getGeoLocation() {
    const {dispatch, id, geoLocationUpdateState} = this.props;

    if (geoLocationUpdateState.progress) {
        return;
    }

    dispatch(getGeoLocationAction(id, this.isDeliveryAddress()));
}

export function onAddressLineChange(event) {
    const {target = {}} = event;
    const {value} = target;
    const {dispatch, id, errors, address} = this.props;
    const newAddressLine = (value || '').trim();
    const oldAddressLine = (address.addressLine || '').trim();

    if (errors && errors.indexOf('geocoder.empty') !== NOT_FOUND) {
        dispatch(deleteEditAddressErrors(id));
    }

    if (!newAddressLine && newAddressLine !== oldAddressLine) {
        dispatch(deleteAddressAction(id, this.isDeliveryAddress()));
    }

    dispatch(editAddressLine(value, address));
    dispatch(clearEditState(id));

    this.setContext();
    this.getSuggest(value);
}

const isElementVisibleAtFirstHalf = (сlientRect = {}) => {
    const {top = 0, height = 0} = сlientRect;
    const {innerHeight: windowInnerHeight = 0} = window || {};

    return top + height < windowInnerHeight / 2;
};

export function onFocus() {
    const {isMobile} = this.props;

    if (!isMobile) {
        return;
    }

    const SHIFT = -10;
    const {pageYOffset = 0} = window;
    const fieldRect = (this.addressLine && this.addressLine.getBoundingClientRect()) || {};

    if (!fieldRect.top || isElementVisibleAtFirstHalf(fieldRect)) {
        return;
    }

    document.body.scrollTop = document.documentElement.scrollTop = fieldRect.top + pageYOffset + SHIFT;
}
