import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {EDIT_MODE_ADDRESSES, EDIT_MODE_DELIVERY_ADDRESSES} from '../../actions/index';

import {setEditMode} from './service';

class AddressesTypeToggle extends React.Component {
    constructor(props) {
        super(props);
        this.displayName = 'AddressesTypeToggle';
        this.setEditMode = setEditMode.bind(this);
    }

    render() {
        const {mode} = this.props;
        const isDeliveryAddressesMode = mode === EDIT_MODE_DELIVERY_ADDRESSES;

        return (
            <div className='addresses-type-toggle'>
                <span
                    className={classnames('addresses-type-toggle-item', {
                        'addresses-type-toggle-item__active': !isDeliveryAddressesMode
                    })}
                    onClick={() => this.setEditMode(EDIT_MODE_ADDRESSES)}
                >
                    {i18n('Profile.addresses.toggle.my')}
                </span>
                <span
                    className={classnames('addresses-type-toggle-item', {
                        'addresses-type-toggle-item__active': isDeliveryAddressesMode
                    })}
                    onClick={() => this.setEditMode(EDIT_MODE_DELIVERY_ADDRESSES)}
                >
                    {i18n('Profile.addresses.toggle.delivery')}
                </span>
            </div>
        );
    }
}

AddressesTypeToggle.propTypes = {
    dispatch: PropTypes.func.isRequired,
    mode: PropTypes.string
};

export default AddressesTypeToggle;
