import {
    SET_ADDRESSES,
    SET_ADDRESSES_PROGRESS_STATE,
    SET_ADDRESSES_EDIT_MODE,
    SET_ADDRESSES_SUGGEST,
    SET_ADDRESSES_CONTEXT,
    SET_ADDRESS,
    SET_EDIT_STATE,
    CLEAR_EDIT_STATE,
    SET_ADDRESSES_ERRORS,
    SET_ADDRESSES_UPDATE_STATE,
    SET_ADDRESSES_SAVING_PROGRESS_STATE,
    SET_ADD_DELIVERY_ADDRESS_MODE,
    DELETE_ADDRESS,
    SET_GEO_LOCATION_STATUS,
    SET_GEO_LOCATION,
    SET_GEO_LOCATION_UPDATE_STATE,
    CLEAR_ADDRESSES_STATE,
    SET_EDIT_ADDRESS_ERRORS,
    DELETE_EDIT_ADDRESS_ERRORS,
    EDIT_MODE_ADDRESSES,
    EDIT_ADDRESS_LINE,
    EDIT_ADDRESS_FLAT
} from './actions';

const NOT_FOUND = 0;
const SPLICE_COUNT = 1;
const defaultState = {
    delivery: [],
    home: {
        id: 'home',
        editedAddressLine: ''
    },
    work: {
        id: 'work',
        editedAddressLine: ''
    },
    defaultDelivery: {
        id: 'delivery',
        editedAddressLine: '',
        editedAddressFlat: ''
    },
    progress: false,
    savingProgress: false,
    mode: EDIT_MODE_ADDRESSES,
    suggest: [],
    context: '',
    editedFields: {},
    errors: [],
    isUpdated: false,
    addDeliveryAddress: false,
    isGeoLocationAvailable: false,
    geoLocation: {},
    geoLocationUpdateState: {
        progress: false,
        id: null
    },
    editErrors: {}
};

export default function addresses(state = defaultState, action = {}) {
    switch (action.type) {
        case SET_ADDRESSES: {
            return Object.assign({}, state, action.addresses);
        }
        case SET_ADDRESSES_PROGRESS_STATE: {
            return Object.assign({}, state, {
                progress: action.progress
            });
        }
        case SET_ADDRESSES_EDIT_MODE: {
            return Object.assign({}, state, {
                mode: action.mode
            });
        }
        case SET_ADDRESSES_SUGGEST: {
            return Object.assign({}, state, {
                suggest: action.suggest
            });
        }
        case SET_ADDRESSES_CONTEXT: {
            return Object.assign({}, state, {
                context: action.context
            });
        }
        case SET_EDIT_STATE: {
            const newState = Object.assign({}, state);

            newState.editedFields[action.id] = true;

            return newState;
        }
        case CLEAR_EDIT_STATE: {
            const newState = Object.assign({}, state);
            const {id} = action;

            if (id) {
                delete newState.editedFields[action.id];
            } else {
                newState.editedFields = {};
            }

            return newState;
        }
        case SET_ADDRESS: {
            const newState = Object.assign({}, {delivery: []}, state);
            const {address} = action;

            if (!address) {
                return newState;
            }

            address.editedAddressLine = address.addressLine;

            const isInvalidAddress = Boolean(newState.editErrors[address.id]);

            address.isValid = !isInvalidAddress;

            if (action.isDeliveryAddress) {
                const index = newState.delivery.findIndex((item) => item.id === address.id);

                if (index >= NOT_FOUND) {
                    newState.delivery[index] = Object.assign({}, newState.delivery[index], address);
                } else {
                    newState.delivery.push(address);
                }
            } else {
                newState[address.id] = address;
            }

            return newState;
        }
        case EDIT_ADDRESS_LINE: {
            const {address = {}, editedAddressLine} = action;
            const isDeliveryAddress = address.id !== 'home' && address.id !== 'work';
            const newAddress = {editedAddressLine, isValid: false};
            const newState = Object.assign({}, state);

            if (isDeliveryAddress && address.id !== 'defaultDelivery') {
                const index = newState.delivery.findIndex((item) => item.id === address.id);

                if (index >= NOT_FOUND) {
                    newState.delivery[index] = Object.assign({}, newState.delivery[index], newAddress);
                } else {
                    newState.delivery.push(newAddress);
                }
            } else {
                if (address.id === 'defaultDelivery') {
                    newAddress.addressLine = editedAddressLine;
                }

                newState[address.id] = Object.assign({}, newState[address.id], newAddress);
            }

            return newState;
        }
        case EDIT_ADDRESS_FLAT: {
            const {address = {}, editedAddressFlat} = action;
            const isDeliveryAddress = address.id !== 'home' && address.id !== 'work';
            const newAddress = {editedAddressFlat};
            const newState = Object.assign({}, state);

            if (isDeliveryAddress && address.id !== 'defaultDelivery') {
                const index = newState.delivery.findIndex((item) => item.id === address.id);

                if (index >= NOT_FOUND) {
                    newState.delivery[index] = Object.assign({}, newState.delivery[index], newAddress);
                } else {
                    newState.delivery.push(newAddress);
                }
            } else {
                newState[address.id] = Object.assign({}, newState[address.id], newAddress);
            }

            return newState;
        }
        case SET_ADDRESSES_ERRORS: {
            return Object.assign({}, state, {
                errors: action.errors
            });
        }
        case SET_ADDRESSES_UPDATE_STATE: {
            return Object.assign({}, state, {
                isUpdated: action.state
            });
        }
        case SET_ADDRESSES_SAVING_PROGRESS_STATE: {
            return Object.assign({}, state, {
                savingProgress: action.progress
            });
        }
        case SET_ADD_DELIVERY_ADDRESS_MODE: {
            return Object.assign({}, state, {
                addDeliveryAddress: action.mode,
                defaultDelivery: Object.assign({}, state.defaultDelivery, {
                    editedAddressLine: '',
                    addressLine: ''
                })
            });
        }
        case DELETE_ADDRESS: {
            const newState = Object.assign({}, state);

            if (action.isDeliveryAddress) {
                const index = newState.delivery.findIndex((item) => item.id === action.id);

                if (index >= NOT_FOUND) {
                    newState.delivery.splice(index, SPLICE_COUNT);
                }
            } else {
                newState[action.id] = defaultState[action.id];
            }

            if (newState.editErrors) {
                delete newState.editErrors[action.id];
            }

            return newState;
        }
        case SET_GEO_LOCATION_STATUS: {
            return Object.assign({}, state, {
                isGeoLocationAvailable: action.isAvailable
            });
        }
        case SET_GEO_LOCATION: {
            return Object.assign({}, state, {
                geoLocation: action.geolocation
            });
        }
        case SET_GEO_LOCATION_UPDATE_STATE: {
            return Object.assign({}, state, {
                geoLocationUpdateState: {
                    progress: action.progress,
                    id: action.id
                }
            });
        }
        case CLEAR_ADDRESSES_STATE: {
            const newState = Object.assign({}, defaultState);

            delete newState.work;
            delete newState.home;
            delete newState.delivery;
            delete newState.isGeoLocationAvailable;
            delete newState.geoLocation;
            delete newState.mode;
            newState.editedFields = {};
            newState.editErrors = {};

            return Object.assign({}, state, newState);
        }
        case SET_EDIT_ADDRESS_ERRORS: {
            const newState = Object.assign({}, {editErrors: {}}, state);
            const addressId = action.id;
            const isDeliveryAddress = addressId !== 'home' && addressId !== 'work';

            newState.editErrors[addressId] = action.errors;

            if (isDeliveryAddress && addressId !== 'defaultDelivery') {
                const index = newState.delivery.findIndex((item) => item.id === addressId);

                if (index >= NOT_FOUND) {
                    newState.delivery[index] = Object.assign({}, newState.delivery[index], {isValid: false});
                }
            } else {
                newState[addressId] = Object.assign({}, newState[addressId], {isValid: false});
            }

            return newState;
        }
        case DELETE_EDIT_ADDRESS_ERRORS: {
            const newState = Object.assign({}, {editErrors: {}}, state);

            delete newState.editErrors[action.id];

            return newState;
        }
        default: {
            return state;
        }
    }
}
